/* ============ */
/* maxoftks.c	*/
/* ============ */
#include <defcodes.h>
#include <maxtdefs.h>
#include <miscdefs.h>
#include <mconf.h>

#define	MAX_SAMPS	((unsigned)RAND_MAX+1U)
int WorkArea[MAX_SAMPS];

static  int  IntCmprFun(const void *Key, const void *Elem)
{
    return (*(int *) Key - *(int *) Elem);
}

/* ==================================================================== */
/* ApplyKStoMaxOfT - Applies Kolmogorov-Smirnov test to Maximum of t	*/
/* ==================================================================== */
void
ApplyKStoMaxOfT(MAXT_DATA_STRU * MaxtData)
{
    UINT    k;
    double  MaxKnNeg, MaxKnPos;

    for (k = 0; k < MaxtData->NumSequences; ++k)
    {
	int	j;
	int	Largest;

	Largest = -1;
	for (j = 0; j < MaxtData->SequenceLen; ++j)
	{
	    int     NextVariate = MaxtData->RandFun();

	    Largest = __max(Largest, NextVariate);
	}

	WorkArea[k] = Largest;
    }

    MaxtData->TotNumGen +=
	MaxtData->SequenceLen * MaxtData->NumSequences;

    qsort((void *)WorkArea, MaxtData->NumSequences, sizeof(int), IntCmprFun);

    MaxKnNeg = MaxKnPos = -100000;
    for (k = 1; k <= MaxtData->NumSequences; ++k)
    {
	double	KSVal, NextKn;

	KSVal = powi((double)WorkArea[k-1]/(double)MAX_SAMPS,
			MaxtData->SequenceLen);

	NextKn = (double)k/(double)MaxtData->NumSequences - KSVal;
	MaxKnPos = __max(MaxKnPos, NextKn);

	NextKn = 1.0/(double)MaxtData->NumSequences - NextKn;
	MaxKnNeg = __max(MaxKnNeg, NextKn);
    }
    MaxtData->KSPos = MaxKnPos;
    MaxtData->KSNeg = MaxKnNeg;
    MaxtData->ProbKSPos = KSmirnov(MaxtData->NumSequences, MaxKnPos);
    MaxtData->ProbKSNeg = KSmirnov(MaxtData->NumSequences, MaxKnNeg);

    /* ------------------------------------------------------------ */
    /* These printouts should be compared to Tables in Knuth, Vol 2 */
    /* ------------------------------------------------------------ */
    P(printf("MaxKn+ = %.8f, P(MaxKn+) = %.8f%%\n",
	sqrt(MaxtData->NumSequences)*MaxKnPos, 100*MaxtData->ProbKSPos));
    P(printf("MaxKn- = %.8f, P(MaxKn-) = %.8f%%\n",
	sqrt(MaxtData->NumSequences)*MaxKnNeg, 100*MaxtData->ProbKSNeg));
}
